<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\Allgemein\ProzessAnfrage;

/**
 * OfferRequest Entity nach BiPRO Norm (utf-8)
 * Daten für eine Angebotsanfrage
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class OfferRequest extends ProzessAnfrage {
	
	/**
	 * Angebot
	 * @var \SoapVar
	 * @internal CT_Angebot
	 */
	protected $Angebot;
	
	/**
	 * Liefert das Angebot
	 * @return \SoapVar
	 */
	public function getAngebot() {
		return $this->Angebot;
	}
	
	/**
	 * Setzt das Angebot
	 * @param \SoapVar $oAngebot
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\OfferRequest
	 */
	public function setAngebot(\SoapVar $oAngebot) {
		$this->Angebot = $oAngebot;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'OfferRequest',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}