<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * PartnerRolle Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.partner
 * @since 2016-10-17
 * @version
 */
class PartnerRolle implements BiPROEntity {
	
	/**
	 * Rolle des Partners
	 * @var \SoapVar
	 * @internal ST_Partnerrolle
	 */
	protected $ArtID;
	
	/**
	 * Liefert die Rolle des Partners
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die Rolle des Partners
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\BiPRO\Entity\Partner\PartnerRolle
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'PartnerRolle',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}