<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Kommunikationsverbindung Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.partner
 * @since 2016-10-17
 * @version
 */
class Kommunikationsverbindung implements BiPROEntity {
	
	/**
	 * Art der Kommunikation
	 * @var \SoapVar
	 * @internal ST_Kommunikationstyp
	 */
	protected $ArtID;
	
	/**
	 * Kommunikationsadresse
	 * @var \SoapVar
	 * @internal ST_Text060
	 */
	protected $Kommunikationsadresse;
	
	/**
	 * Liefert die Art der Kommunikation
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die Art der Kommunikation
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Kommunikationsverbindung
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * Liefert die Kommunikationsadresse
	 * @return \SoapVar
	 */
	public function getKommunikationsadresse() {
		return $this->Kommunikationsadresse;
	}
	
	/**
	 * Setzt die Kommunikationsadresse
	 * @param \SoapVar $oKommunikationsadresse
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Kommunikationsverbindung
	 */
	public function setKommunikationsadresse(\SoapVar $oKommunikationsadresse) {
		$this->Kommunikationsadresse = $oKommunikationsadresse;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'Kommunikationsverbindung',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}