<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * VermittlerRolle Entity nach BiPRO Norm (utf-8)
 * Rolle(n) des Vermittlers innerhalb des Geschaeftsvorgangs.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2016-10-20
 * @version
 */
class VermittlerRolle implements BiPROEntity {
	/**
	 * ArtID
	 * @var \SoapVar
	 * @internal ST_Vermittlerrolle
	 */
	protected $ArtID;
	
	/**
	 * Angaben zur möglichen Anteilsverteilung von Untervermittlern
	 * @var \SoapVar
	 * @internal ST_Dezimalzahl
	 */
	protected $Wert;
	
	/**
	 * Wertschlüssel
	 * @var \SoapVar
	 * @internal STE_VermittlerrolleSchluessel
	 */
	protected $Wertschluessel;
	
	/**
	 * Werteinheit
	 * @var \SoapVar
	 * @internal ST_Berechnungseinheit
	 */
	protected $Werteinheit;
	
	/**
	 * Vermittlertyp
	 * @var \SoapVar
	 * @internal ST_Vermittlertyp
	 */
	protected $Vermittlertyp;
	
	/**
	 * Liefert die ArtID
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die ArtID
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\VermittlerRolle
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * Liefert den Wert
	 * @return \SoapVar
	 */
	public function getWert() {
		return $this->Wert;
	}
	
	/**
	 * Setzt den Wert
	 * @param \SoapVar $oWert
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\VermittlerRolle
	 */
	public function setWert(\SoapVar $oWert) {
		$this->Wert = $oWert;
		return $this;
	}
	
	/**
	 * Liefert den Werteschlüssel
	 * @return \SoapVar
	 */
	public function getWertschluessel() {
		return $this->Wertschluessel;
	}
	
	/**
	 * Setzt den Werteschlüssel
	 * @param \SoapVar $oWertschluessel
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\VermittlerRolle
	 */
	public function setWertschluessel(\SoapVar $oWertschluessel) {
		$this->Wertschluessel = $oWertschluessel;
		return $this;
	}
	
	/**
	 * Liefert die Werteinheit
	 * @return \SoapVar
	 */
	public function getWerteinheit() {
		return $this->Werteinheit;
	}
	
	/**
	 * Setzt die Werteinheit
	 * @param \SoapVar $oWerteinheit
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\VermittlerRolle
	 */
	public function setWerteinheit(\SoapVar $oWerteinheit) {
		$this->Werteinheit = $oWerteinheit;
		return $this;
	}
	
	/**
	 * Liefert den Vermittlertyp
	 * @return \SoapVar
	 */
	public function getVermittlertyp() {
		return $this->Vermittlertyp;
	}
	
	/**
	 * Setzt den Vermittlertyp
	 * @param \SoapVar $oVermittlertyp
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\VermittlerRolle
	 */
	public function setVermittlertyp(\SoapVar $oVermittlertyp) {
		$this->Vermittlertyp = $oVermittlertyp;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'VermittlerRolle',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}