<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * ProzessAnfrage Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2016-10-17
 * @version
 */
class ProzessAnfrage implements BiPROEntity {
	
	/**
	 * BiPRO Version
	 * @var \SoapVar
	 * @internal ST_Version
	 */
	protected $BiproVersion;
	
	/**
	 * Liefert das Version Attribut
	 * @return SoapVar
	 */
	public function getBiproVersion() {
		return $this->BiproVersion;
	}
	
	/**
	 * Setzt das Version Attribut
	 * @param \SoapVar $oBiproVersion
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\ProzessAnfrage
	 */
	public function setBiproVersion(\SoapVar $oBiproVersion) {
		$this->BiproVersion = $oBiproVersion;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/allgemein',
			'ProzessAnfrage',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}