<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Dynamik Entity nach BiPRO Norm (utf-8)
 * Rechtlich vereinbarte Dynamik auf Beitraege oder Leistungen.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class Dynamik implements BiPROEntity {
	
	/**
	 * Art ID
	 * @var \SoapVar
	 * @internal STE_Dynamik
	 */
	protected $ArtID;
	
	/**
	 * Frequenz
	 * @var \SoapVar
	 * @internal STE_Frequenz
	 */
	protected $Frequenz;
	
	/**
	 * Hier wird der Prozentanteil ohne Prozentzeichen eingetragen. z.B. 50 = 50% oder 12,5 = 12,5%
	 * @var \SoapVar
	 * @internal ST_Prozent
	 */
	protected $Wert;
	
	/**
	 * Beginn
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Beginn;
	
	/**
	 * Ablauf
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Ablauf;
	
	/**
	 * Unterscheidet, ob es sich bei der beschriebenen Dynamik um eine Beitrags- oder 
	 * Leistungsdynamik handelt.
	 * @var \SoapVar
	 * @internal ST_DynamikKategorieID
	 */
	protected $KategorieID;
	
	/**
	 * Dynamik fließt nicht in die Beitrags- bzw. Leistungsverläufe ein.
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $Hochrechnung;
	
	/**
	 * Liefert die Art ID
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die Art ID
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dynamik
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * Liefert die Frequenz
	 * @return \SoapVar
	 */
	public function getFrequenz() {
		return $this->Frequenz;
	}
	
	/**
	 * Setzt die Frequenz
	 * @param \SOapVar $oFrequenz
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dynamik
	 */
	public function setFrequenz(\SOapVar $oFrequenz) {
		$this->Frequenz = $oFrequenz;
		return $this;
	}
	
	/**
	 * Liefert den Wert
	 * @return \SoapVar
	 */
	public function getWert() {
		return $this->Wert;
	}
	
	/**
	 * Setzt den Wert
	 * @param \SoapVar $oWert
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dynamik
	 */
	public function setWert(\SoapVar $oWert) {
		$this->Wert = $oWert;
		return $this;
	}
	
	/**
	 * Liefert den Beginn
	 * @return \SoapVar
	 */
	public function getBeginn() {
		return $this->Beginn;
	}
	
	/**
	 * Setzt den Beginn
	 * @param \SoapVar $oBeginn
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dynamik
	 */
	public function setBeginn(\SoapVar $oBeginn) {
		$this->Beginn = $oBeginn;
		return $this;
	}
	
	/**
	 * Liefert den Ablauf
	 * @return \SoapVar
	 */
	public function getAblauf() {
		return $this->Ablauf;
	}
	
	/**
	 * Setzt den Ablauf
	 * @param \SoapVar $oAblauf
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dynamik
	 */
	public function setAblauf(\SoapVar $oAblauf) {
		$this->Ablauf = $oAblauf;
		return $this;
	}
	
	/**
	 * Liefert die Kategorie ID
	 * @return \SoapVar
	 */
	public function getKategorieID() {
		return $this->KategorieID;
	}
	
	/**
	 * Setzt die Kategorie ID
	 * @param \SoapVar $oKategorieID
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dynamik
	 */
	public function setKategorieID(\SoapVar $oKategorieID) {
		$this->KategorieID = $oKategorieID;
		return $this;
	}
	
	/**
	 * Setzt die Hochrechnung
	 * @return \SoapVar
	 */
	public function getHochrechnung() {
		return $this->Hochrechnung;
	}
	
	/**
	 * Liefert die Hochrechnung
	 * @param \SoapVar $oHochrechnung
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Dynamik
	 */
	public function setHochrechnung(\SoapVar $oHochrechnung) {
		$this->Hochrechnung = $oHochrechnung;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Dynamik',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}