<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Berufstaetigkeit Entity nach BiPRO Norm (utf-8)
 * Angaben zur Berufstätigkeit
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmdia.bipro
 * @subpackage entity.partner
 * @since 2016-10-18
 * @version
 */
class Berufstaetigkeit implements BiPROEntity {
	
	/**
	 * Name eines bestimmten Berufs. Werden die Attribute "Beruf" UND "Berufschluessel" gemeinsam 
	 * verwendet, DUERFEN sich die Werte NICHT widersprechen. Der Beruf kann über die Norm 480.2 
	 * Berufssuche ermittelt werden. Werden Beruf und Berufsschlüssel geliefert, hat der 
	 * Berufsschlüssel vorrang. Der Provider DARF im Response den Beruf aus dem Berufsschlüssel 
	 * ermitteln ggf überschreiben, kenntlich machen und zurückgeben.
	 * @var \SoapVar
	 * @internal ST_Text255
	 */
	protected $Beruf;
	
	/**
	 * Stellung im Beruf
	 * @var \SoapVar
	 * @internal STE_StellungImBeruf
	 */
	protected $StellungImBeruf;
	
	/**
	 * Mitarbeiteranzahl
	 * @var \SoapVar
	 * @internal ST_Ganzzahl
	 */
	protected $Mitarbeiteranzahl;
	
	/**
	 * Besoldungsgruppe
	 * @var \SoapVar
	 * @internal ST_Text006
	 */
	protected $Besoldungsgruppe;
	
	/**
	 * Selbstständig seit
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $SelbststaendigSeit;
	
	/**
	 * Arbeitsvertrag befristet bis
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $ArbeitsvertragBefristetBis;
	
	/**
	 * Datumd es Betriebseintritts
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Betriebseintritt;
	
	/**
	 * Anteil der körperlichen Tätigkeit
	 * @var \SoapVar
	 * @internal ST_Prozent
	 */
	protected $KoerperlichTaetig;
	
	/**
	 * Branche
	 * @var \SoapVar
	 * @internal STE_BerufsBranche
	 */
	protected $Branche;
	
	/**
	 * Ja, wenn der Partner im Öffentlichen Dienst beschäftigt ist
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $OeffentlicherDienst;
	
	/**
	 * Anteil der Tätigkeiten im Außendienst in Prozenz
	 * @var \SoapVar
	 * @internal ST_Prozent
	 */
	protected $AnteilAussendienst;
	
	/**
	 * Angabe, ob der Partner beruflich (auch teilweise) aufischtsführend tätig ist
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $Aufsichtsfuehrend;
	
	/**
	 * Feststellung, ob der Partner beruflich (auch teilweise) mitarbeitend tätig ist
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $Mitarbeitend;
	
	/**
	 * Identifikation eines bestimmten Berufs. Werden die Attribute "Berufschluessel" UND "Beruf" 
	 * gemeinsam verwendet, DUERFEN sich die Werte NICHT widersprechen. Der Berufsschlüssel kann über 
	 * die Norm 480.2 Berufssuche ermittelt werden. Werden Beruf und Berufsschlüssel geliefert, hat 
	 * der Berufsschlüssel vorrang. Der Provider DARF im Response den Beruf aus dem Berufsschlüssel 
	 * ermitteln ggf überschreiben, kenntlich machen und zurückgeben.
	 * @var \SoapVar
	 * @internal ST_Berufsschluessel
	 */
	protected $Berufsschluessel;
	
	/**
	 * Zur Bestimmung der Risikogruppe wird zusätzlich zur Angabe der körperlichen Tätigkeit 
	 * (partner:KoerperlichTaetig) auch die Angabe der Tätigkeit im Büro bzw. ob nicht körperlich 
	 * Tätig, benötigt. Die Summe beider Werte muss nicht zwangsläufig 100% ergeben, um die 
	 * Risikogruppe zu bestimmen.
	 * @var \SoapVar
	 * @internal ST_Prozent
	 */
	protected $NichtKoerperlichTaetig;
	
	/**
	 * Liefert den Beruf
	 * @return \SoapVar
	 */
	public function getBeruf() {
		return $this->Beruf;
	}
	
	/**
	 * Setzt den Beruf
	 * @param \SoapVar $oBeruf
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setBeruf(\SoapVar $oBeruf) {
		$this->Beruf = $oBeruf;
		return $this;
	}
	
	/**
	 * Liefert die Stellung im Beruf
	 * @return \SoapVar
	 */
	public function getStellungImBeruf() {
		return $this->StellungImBeruf;
	}
	
	/**
	 * Setzt die Stellung im Beruf
	 * @param \SoapVar $oStellungImBeruf
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setStellungImBeruf(\SoapVar $oStellungImBeruf) {
		$this->StellungImBeruf = $oStellungImBeruf;
		return $this;
	}
	
	/**
	 * Liefert die Mitarbeiteranzahl
	 * @return \SoapVar
	 */
	public function getMitarbeiteranzahl() {
		return $this->Mitarbeiteranzahl;
	}
	
	/**
	 * Setzt die Mitarbeiteranzahl
	 * @param \SoapVar $oMitarbeiteranzahl
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setMitarbeiteranzahl(\SoapVar $oMitarbeiteranzahl) {
		$this->Mitarbeiteranzahl = $oMitarbeiteranzahl;
		return $this;
	}
	
	/**
	 * Liefert die Besoldungsgruppe
	 * @return \SoapVar
	 */
	public function getBesoldungsgruppe() {
		return $this->Besoldungsgruppe;
	}
	
	/**
	 * Setzt die Besoldungsgruppe
	 * @param \SoapVar $oBesoldungsgruppe
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setBesoldungsgruppe(\SoapVar $oBesoldungsgruppe) {
		$this->Besoldungsgruppe = $oBesoldungsgruppe;
		return $this;
	}
	
	/**
	 * Setzt das Datum der Selbstständigkeit
	 * @return \SoapVar
	 */
	public function getSelbststaendigSeit() {
		return $this->SelbststaendigSeit;
	}
	
	/**
	 * Setzt das Datum der Selbstständigkeit
	 * @param \SoapVar $oSelbststaendigSeit
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setSelbststaendigSeit(\SoapVar $oSelbststaendigSeit) {
		$this->SelbststaendigSeit = $oSelbststaendigSeit;
		return $this;
	}
	
	/**
	 * Setzt die Befristung des Arbeitsvertrages
	 * @return \SoapVar
	 */
	public function getArbeitsvertragBefristetBis() {
		return $this->ArbeitsvertragBefristetBis;
	}
	
	/**
	 * Setzt die Befristung des Arbeitsvertrages
	 * @param \SoapVar $oArbeitsvertragBefristetBis
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setArbeitsvertragBefristetBis(\SoapVar $oArbeitsvertragBefristetBis) {
		$this->ArbeitsvertragBefristetBis = $oArbeitsvertragBefristetBis;
		return $this;
	}
	
	/**
	 * Liefert den Betriebseintritt
	 * @return \SoapVar
	 */
	public function getBetriebseintritt() {
		return $this->Betriebseintritt;
	}
	
	/**
	 * Setzt den Betriebseintritt
	 * @param \SoapVar $oBetriebseintritt
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setBetriebseintritt(\SoapVar $oBetriebseintritt) {
		$this->Betriebseintritt = $oBetriebseintritt;
		return $this;
	}
	
	/**
	 * Liefert den Prozentsatz der körperlichen Tätigkeit
	 * @return \SoapVar
	 */
	public function getKoerperlichTaetig() {
		return $this->KoerperlichTaetig;
	}
	
	/**
	 * Setzt den Prozentsatz der körperlichen Tätigkeit
	 * @param \SoapVar $oKoerperlichTaetig
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setKoerperlichTaetig(\SoapVar $oKoerperlichTaetig) {
		$this->KoerperlichTaetig = $oKoerperlichTaetig;
		return $this;
	}
	
	/**
	 * Liefert die Branche
	 * @return \SoapVar
	 */
	public function getBranche() {
		return $this->Branche;
	}
	
	/**
	 * Setzt die Branche
	 * @param \SoapVar $oBranche
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setBranche(\SoapVar $oBranche) {
		$this->Branche = $oBranche;
		return $this;
	}
	
	/**
	 * Liefert den Status zum öffentlichen Dienst
	 * @return \SoapVar
	 */
	public function getOeffentlicherDienst() {
		return $this->OeffentlicherDienst;
	}
	
	/**
	 * Setzt den Satus zum öffentlichen Dienst
	 * @param \SoapVar $oOeffentlicherDienst
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setOeffentlicherDienst(\SoapVar $oOeffentlicherDienst) {
		$this->OeffentlicherDienst = $oOeffentlicherDienst;
		return $this;
	}
	
	/**
	 * Liefert den Anteil des Außendiensts
	 * @return \SoapVar
	 */
	public function getAnteilAussendienst() {
		return $this->AnteilAussendienst;
	}
	
	/**
	 * Setzt den Anteil des Außendiensts
	 * @param \SoapVar $oAnteilAussendienst
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setAnteilAussendienst(\SoapVar $oAnteilAussendienst) {
		$this->AnteilAussendienst = $oAnteilAussendienst;
		return $this;
	}
	
	/**
	 * Setzt den Status Aufsichtsführend
	 * @return \SoapVar
	 */
	public function getAufsichtsfuehrend() {
		return $this->Aufsichtsfuehrend;
	}
	
	/**
	 * Setzt den Status Aufsichtsführend
	 * @param \SoapVar $oAufsichtsfuehrend
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setAufsichtsfuehrend(\SoapVar $oAufsichtsfuehrend) {
		$this->Aufsichtsfuehrend = $oAufsichtsfuehrend;
		return $this;
	}
	
	/**
	 * Liefert den Status Mitarbeitend
	 * @return SoapVar
	 */
	public function getMitarbeitend() {
		return $this->Mitarbeitend;
	}
	
	/**
	 * Setzt den Status Mitarbeitend
	 * @param \SoapVar $oMitarbeitend
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setMitarbeitend(\SoapVar $oMitarbeitend) {
		$this->Mitarbeitend = $oMitarbeitend;
		return $this;
	}
	
	/**
	 * Liefert den Berufsschlüssel
	 * @return \SoapVar
	 */
	public function getBerufsschluessel() {
		return $this->Berufsschluessel;
	}
	
	/**
	 * Setzt den Berufsschlüssel
	 * @param \SoapVar $oBerufsschluessel
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setBerufsschluessel(\SoapVar $oBerufsschluessel) {
		$this->Berufsschluessel = $oBerufsschluessel;
		return $this;
	}
	
	/**
	 * Liefert den Anteil der nicht körperlichen Tätigkeiten 
	 * @return \SoapVar
	 */
	public function getNichtKoerperlichTaetig() {
		return $this->NichtKoerperlichTaetig;
	}
	
	/**
	 * Setzt den Anteil der nicht körperlichen Tätigkeiten
	 * @param \SoapVar $oNichtKoerplerichTaetig
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Berufstaetigkeit
	 */
	public function setNichtKoerperlichTaetig(\SoapVar $oNichtKoerplerichTaetig) {
		$this->NichtKoerperlichTaetig = $oNichtKoerplerichTaetig;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'Berufstaetigkeit',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}