<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Versicherungssumme oder Leistung Entity nach BiPRO Norm (utf-8)
 * Da sich herausgestellt hat, dass es zwischen Versicherungssummen (Komposit) und Leistungen (Leben) 
 * abgesehen vom Namen keine modellierungsrelevanten Unterschiede gibt, sind beide synonym durch 
 * diesen Datentypen repraesentiert.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class VersicherungssummeOderLeistung implements BiPROEntity {
	
	/**
	 * ArtID
	 * @var \SoapVar
	 * @internal STE_VersicherungssummeOderLeistung
	 */
	protected $ArtID;
	
	/**
	 * Wert
	 * @var \SoapVar
	 * @internal ST_Dezimalzahl
	 */
	protected $Wert;
	
	/**
	 * Da die Bedeutung und Verwendung des Attributes und des Datentyps nicht klar ist, DARF es nicht
	 * mehr benutzt werden und wird in einem späteren Release gelöscht.
	 * @var \SoapVar
	 * @internal STE_LeistungSchluessel
	 */
	protected $Wertschluessel;
	
	/**
	 * Werteinheit
	 * @var \SoapVar
	 * @internal ST_Werteinheit
	 */
	protected $Werteinheit;
	
	/**
	 * Währung
	 * @var \SoapVar
	 * @internal ST_Waehrungsschluessel
	 */
	protected $Waehrung;
	
	/**
	 * Auszahlungsweise
	 * @var \SoapVar
	 * @internal ST_Zahlungsweise
	 */
	protected $Auszahlungsweise;
	
	/**
	 * Liefert die Art ID
	 * @return \SoapVar
	 */
	public function getArtID() {
		return $this->ArtID;
	}
	
	/**
	 * Setzt die Art ID
	 * @param \SoapVar $oArtID
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\VersicherungssummeOderLeistung
	 */
	public function setArtID(\SoapVar $oArtID) {
		$this->ArtID = $oArtID;
		return $this;
	}
	
	/**
	 * Liefert den Wert
	 * @return \SoapVar
	 */
	public function getWert() {
		return $this->Wert;
	}
	
	/**
	 * Setzt den Wert
	 * @param \SoapVar $oWert
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\VersicherungssummeOderLeistung
	 */
	public function setWert(\SoapVar $oWert) {
		$this->Wert = $oWert;
		return $this;
	}
	
	/**
	 * Liefert den Wertschlüssel
	 * @return \SoapVar
	 */
	public function getWertschluessel() {
		return $this->Wertschluessel;
	}
	
	/**
	 * Setzt den Wertschlüssel
	 * @param \SoapVar $oWertschluessel
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\VersicherungssummeOderLeistung
	 */
	public function setWertschluessel(\SoapVar $oWertschluessel) {
		$this->Wertschluessel = $oWertschluessel;
		return $this;
	}
	
	/**
	 * Liefert die Werteinheit
	 * @return \SoapVar
	 */
	public function getWerteinheit() {
		return $this->Werteinheit;
	}
	
	/**
	 * Setzt die Werteinheit
	 * @param \SoapVar $oWerteinheit
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\VersicherungssummeOderLeistung
	 */
	public function setWerteinheit(\SoapVar $oWerteinheit) {
		$this->Werteinheit = $oWerteinheit;
		return $this;
	}
	
	/**
	 * Liefert die Währung
	 * @return \SoapVar
	 */
	public function getWaehrung() {
		return $this->Waehrung;
	}
	
	/**
	 * Setzt die Währung
	 * @param \SoapVar $oWaehrung
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\VersicherungssummeOderLeistung
	 */
	public function setWaehrung(\SoapVar $oWaehrung) {
		$this->Waehrung = $oWaehrung;
		return $this;
	}
	
	/**
	 * Liefert die Auszahlungsweise
	 * @return \SoapVar
	 */
	public function getAuszahlungsweise() {
		return $this->Auszahlungsweise;
	}
	
	/**
	 * Setzt die Auszahlungsweise
	 * @param \SoapVar $oAuszahlungsweise
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\VersicherungssummeOderLeistung
	 */
	public function setAuszahlungsweise(\SoapVar $oAuszahlungsweise) {
		$this->Auszahlungsweise = $oAuszahlungsweise;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'VersicherungssummeOderLeistung',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}