<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Bezugsrecht Entity nach BiPRO Norm (utf-8)
 * Angaben zu Bezugsrechten und -berechtigten
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class Bezugsrecht implements BiPROEntity {
	
	/**
	 * Leistungsfall
	 * @var \SoapVar
	 * @internal ST_Leistungsfall
	 */
	protected $Leistungsfall;
	
	/**
	 * Unwiderrufliches Bezugsrecht
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $UnwiderruflichesBezugsrecht;
	
	/**
	 * Index Berechtigter
	 * @var \SoapVar
	 * @internal ST_Bezugsrecht
	 */
	protected $IndexBerechtigter;
	
	/**
	 * Individualabzug
	 * @var \SoapVar
	 * @internal ST_Text255
	 */
	protected $Individualabzug;
	
	/**
	 * Liefert den Leistungsfall
	 * @return \SoapVar
	 */
	public function getLeistungsfall() {
		return $this->Leistungsfall;
	}
	
	/**
	 * Setzt den Leistungsfall
	 * @param \SoapVar $oLeistungsfall
	 */
	public function setLeistungsfall(\SoapVar $oLeistungsfall) {
		$this->Leistungsfall = $oLeistungsfall;
	}
	
	/**
	 * Liefert das unwiderrufliche Bezugsrecht
	 * @return \SoapVar
	 */
	public function getUnwiderruflichesBezugsrecht() {
		return $this->UnwiderruflichesBezugsrecht;
	}
	
	/**
	 * Setzt das unwiderrufliche Bezugsrecht
	 * @param \SoapVar $oUnwiderruflichesBezugsrecht
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Bezugsrecht
	 */
	public function setUnwiderruflichesBezugsrecht(\SoapVar $oUnwiderruflichesBezugsrecht) {
		$this->UnwiderruflichesBezugsrecht = $oUnwiderruflichesBezugsrecht;
		return $this;
	}
	
	/**
	 * Liefert den Index des Berechtigten
	 * @return \SoapVar
	 */
	public function getIndexBerechtigter() {
		return $this->IndexBerechtigter;
	}
	
	/**
	 * Setzt den Index des Beziehungsberechtigten
	 * @param \SoapVar $oIndexBerechtigter
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Bezugsrecht
	 */
	public function setIndexBerechtigter(\SoapVar $oIndexBerechtigter) {
		$this->IndexBerechtigter = $oIndexBerechtigter;
		return $this;
	}
	
	/**
	 * Liefert den Individualabzug
	 * @return \SoapVar
	 */
	public function getIndividualabzug() {
		return $this->Individualabzug;
	}
	
	/**
	 * Setzt den Individualabzug
	 * @param \SoapVar $oIndividualabzug
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\Bezugsrecht
	 */
	public function setIndividualabzug(\SoapVar $oIndividualabzug) {
		$this->Individualabzug = $oIndividualabzug;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Bezugsrecht',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}