<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Status Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2016-10-17
 * @version
 */
class Status implements BiPROEntity {
	
	/**
	 * Prozess-ID
	 * Eindeutige Identifizierung des fachlichen Prozesses beim Versicherer
	 * @var \SoapVar
	 * @internal ST_ProzessID
	 */
	protected $ProzessID;
	
	/**
	 * Status-ID
	 * Eindeutige Identifizierung der Statusmeldung
	 * @var \SoapVar
	 * @internal ST_Status
	 */
	protected $StatusID;
	
	/**
	 * Zeitstempel
	 * Aktuelles Datum und Uhrzeit zum Bearbeitungszeitpunkt
	 * @var \SoapVar
	 * @internal ST_Zeitstempel
	 */
	protected $Zeitstempel;
	
	/**
	 * Historien-Index
	 * Aktueller Index der Statusmeldung
	 * @var \SoapVar
	 * @internal ST_Ganzzahl
	 */
	protected $Historienindex;
	
	/**
	 * Historien-Zähler
	 * Anzahl aller Statusmeldungen zum Prozess-ID
	 * @var \SoapVar
	 * @internal ST_Ganzzahl
	 */
	protected $Historienzaehler;
	
	/**
	 * Statusmeldung
	 * Optionale Statusmeldung als Klartext
	 * @var \SoapVar
	 * @internal ST_Text255
	 */
	protected $Text;
	
	/**
	 * Prozess abgeschlossen?
	 * Kennung, ob es sich um einen fachlich synchronen oder asynchronen Prozess handelt (mit Schwebeverarbeitung)
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $Asynchron;
	
	/**
	 * Nächste Statusanfrage
	 * Frühestlohnender Zeitpunkt für nächste Anfrage, ob sich der Status eines asynchronen Prozesses verändert hat
	 * @var \SoapVar
	 * @internal ST_Zeitstempel
	 */
	protected $NaechsteStatusanfrage;
	
	/**
	 * Zeitpunkt bis zu dem die zum Vorgang gehoerigen Daten beim Anbieter vorgehalten werden.
	 * @var \SoapVar
	 * @internal ST_Zeitstempel
	 */
	protected $gueltigkeitsEnde;
	
	/**
	 * Meldung
	 * @var \SoapVar
	 * @internal CT_Meldung
	 */
	protected $Meldung;
	
	/**
	 * Liefert die Prozess ID
	 * @return \SoapVar
	 */
	public function getProzessID() {
		return $this->ProzessID;
	}
	
	/**
	 * Setzt die Prozess ID
	 * @param \SoapVar $oProzessID
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setProzessID(\SoapVar $oProzessID) {
		$this->ProzessID = $oProzessID;
		return $this;
	}
	
	/**
	 * Liefert die Status ID
	 * @return \SoapVar
	 */
	public function getStatusID() {
		return $this->StatusID;
	}
	
	/**
	 * Setzt die Status ID
	 * @param \SoapVar $oStatusID
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setStatusID(\SoapVar $oStatusID) {
		$this->StatusID = $oStatusID;
		return $this;
	}
	
	/**
	 * Liefert den Zeitstempel
	 * @return \SoapVar
	 */
	public function getZeitstempel() {
		return $this->Zeitstempel;
	}
	
	/**
	 * Setzt den Zeitstempel
	 * @param \SoapVar $oZeitstempel
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setZeitstempel(\SoapVar $oZeitstempel) {
		$this->Zeitstempel = $oZeitstempel;
		return $this;
	}
	
	/**
	 * Liefert den Historienindex
	 * @return \SoapVar
	 */
	public function getHistorienindex() {
		return $this->Historienindex;
	}
	
	/**
	 * Setzt den Historienindex
	 * @param \SoapVar $oHistorienindex
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setHistorienindex(\SoapVar $oHistorienindex) {
		$this->Historienindex = $oHistorienindex;
		return $this;
	}
	
	/**
	 * Liefert den Historienzähler
	 * @return \SoapVar
	 */
	public function getHistorienzaehler() {
		return $this->Historienzaehler;
	}
	
	/**
	 * Setzt den Historienzähler
	 * @param \SoapVar $oHistorienzaehler
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setHistorienzaehler(\SoapVar $oHistorienzaehler) {
		$this->Historienzaehler = $oHistorienzaehler;
		return $this;
	}
	
	/**
	 * Liefert den Text
	 * @return \SoapVar
	 */
	public function getText() {
		return $this->Text;
	}
	
	/**
	 * Setzt den Text
	 * @param \SoapVar $oText
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setText(\SoapVar $oText) {
		$this->Text = $oText;
		return $this;
	}
	
	/**
	 * Liefert den Asynchron Wert
	 * @return \SoapVar
	 */
	public function getAsynchron() {
		return $this->Asynchron;
	}
	
	/**
	 * Setzt den Asynchron Wert
	 * @param \SoapVar $oAsynchron
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setAsynchron(\SoapVar $oAsynchron) {
		$this->Asynchron = $oAsynchron;
		return $this;
	}
	
	/**
	 * Liefert den Zeitstempel der nächsten Statusanfrage
	 * @return \SoapVar
	 */
	public function getNaechsteStatusanfrage() {
		return $this->NaechsteStatusanfrage;
	}
	
	/**
	 * Setzt den Zeitstempel der nächsten Statusanfrage
	 * @param \SoapVar $oNaechsteStatusanfrage
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setNaechsteStatusanfrage(\SoapVar $oNaechsteStatusanfrage) {
		$this->NaechsteStatusanfrage = $oNaechsteStatusanfrage;
		return $this;
	}
	
	/**
	 * Liefert das Gültigkeitsende
	 * @return \SoapVar
	 */
	public function getGueltigkeitsEnde() {
		return $this->gueltigkeitsEnde;
	}
	
	/**
	 * Setzt das Gültikgeitsende
	 * @param \SoapVar $oGueltigskeitsEnde
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setGueltigkeitsEnde(\SoapVar $oGueltigskeitsEnde) {
		$this->gueltigkeitsEnde = $oGueltigskeitsEnde;
		return $this;
	}
	
	/**
	 * Liefert die Meldung
	 * @return \SoapVar
	 */
	public function getMeldung() {
		return $this->Meldung;
	}
	
	/**
	 * Setzt die Meldung
	 * @param \SoapVar $oMeldung
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\Status
	 */
	public function setMeldung(\SoapVar $oMeldung) {
		$this->Meldung = $oMeldung;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/allgemein',
			'Status',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}