<?php
namespace MMNewmedia\BiPRO\Entity;

/**
 * SecurityContextToken Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-03-03
 * @version
 */
class SecurityContextToken implements BiPROEntity {
	
	/**
	 * Identifier
	 * @var \SoapVar
	 */
	protected $Identifier;
	
	/**
	 * Liefert den Identifier
	 * @return \SoapVar
	 */
	public function getIdentifier() {
		return $this->Identifier;
	}
	
	/**
	 * Setzt den Identifier
	 * @param \SoapVar $oIdentifer
	 */
	public function setIdentifier(\SoapVar $oIdentifer) {
		$this->Identifier = $oIdentifer;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://schemas.xmlsoap.org/ws/2005/02/sc',
			'SecurityContextToken',
			'http://schemas.xmlsoap.org/ws/2005/02/sc'
		);
		
		return $oEncodedObject;
	}
}