<?php
namespace MMNewmedia\BiPRO\Entity;

/**
 * Datenobjekt für die RequestSecurityToken Methode eines Security Token Webservices (utf-8)
 * Diese Klasse wird als Parameter an die RequestSecurityToken Methode übergeben
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-03-03
 * @version
 */
class RequestSecurityToken implements BiPROEntity {
	
	/**
	 * TokenType
	 * @var \SoapVar
	 */
	protected $TokenType;
	
	/**
	 * RequestType
	 * @var \SoapVar
	 */
	protected $RequestType;
	
	/**
	 * Liefert den TokenType
	 * @return \SoapVar
	 */
	public function getTokenType()
	{
		return $this->TokenType;
	}
	
	/**
	 * Setzt den TokenType
	 * @param \SoapVar $oTokenType
	 */
	public function setTokenType(\SoapVar $oTokenType)
	{
		$this->TokenType = $oTokenType;
	}
	
	/**
	 * Liefert den RequestType
	 * @return \SoapVar
	 */
	public function getRequestType()
	{
		return $this->RequestType;
	}
	
	/**
	 * Setzt den RequestType
	 * @param \SoapVar $oRequestType
	 */
	public function setRequestType(\SoapVar $oRequestType)
	{
		$this->RequestType = $oRequestType;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'RequestSecurityToken',
			'http://schemas.xmlsoap.org/ws/2005/02/trust'
		);
	
		return $oEncodedObject;
	}
}