<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

use MMNewmedia\BiPRO\Entity\Allgemein\Geschaeftsvorgang;

/**
 * Antrag Entity nach BiPRO Norm (utf-8)
 * Geschaeftsvorgang Antrag. Darf nicht spartenspezifisch abgeleitet werden, da sonst die 
 * spartenuebergreifende Buendelung von Produkten nicht mehr moeglich waere.
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class Antrag extends Geschaeftsvorgang {
	
	/**
	 * Hauptfälligkeit
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Hauptfaelligkeit;
	
	/**
	 * Aktionskennzeichen
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Aktionskennzeichen;
	
	/**
	 * Antragsdatum
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Antragsdatum;
	
	/**
	 * Wurden die Bedingungen zur Kenntnis genommen?
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $BedingungenZurKenntnisGenommen;
	
	/**
	 * VN stimmt Telefonwerbung zu
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $TelefonwerbungErwuenscht;
	
	/**
	 * VN stimmt Telefonwerbung zu
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $MailwerbungErwuenscht;
	
	/**
	 * Besondere Vereinbarungen
	 * @var \SoapVar
	 * @internal ST_Text1000
	 */
	protected $BesondereVereinbarungen;
	
	/**
	 * Zuordnungsmerkmal des Vermittlers, z. B. Niederlassung/Büro des Vermittlers, Sachbearbeiter 
	 * des Vermittlers, Vertragsnummer des Vermittlers. Das im Antrag übermittelte AktenzeichenVM 
	 * MUSS vom Versicherer bei der Policierung zum Vertrag gespeichert und bei vertragsbezogenen 
	 * Geschäftsvorgängen im Objekt Vertrag ausgegeben werden.
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $AktenzeichenVM;
	
	/**
	 * Zuordnungsmerkmal des Versicherungsnehmers (VN), z. B. Niederlassung, Betriebsstätte, Abteilung, 
	 * Kostenstelle des VN. Das im Antrag übermittelte AktenzeichenVN MUSS vom Versicherer bei der 
	 * Policierung zum Vertrag gespeichert und bei vertragsbezogenen Geschäftsvorgängen im Objekt 
	 * Vertrag ausgegeben werden.
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $AktenzeichenVN;
	
	/**
	 * Einwilligung Informationsanfrage
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $EinwilligungInformationsanfrage;
	
	/**
	 * VVG (Versicherungsvertragsgesetz) Beratungsverzicht
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $VVGBeratungsverzicht;
	
	/**
	 * Ist der Antrag unterschrieben?
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $AntragUnterschrieben;
	
	/**
	 * Zustimmung Finanzdienstleister
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $ZustimmungFinanzdienstleister;
	
	/**
	 * Wurde die Datenschutzerklärung unterschrieben?
	 * @var \SoapVar
	 * @internal ST_JaNein
	 */
	protected $DatenschutzerklaerungUnterschrieben;
	
	/**
	 * Abschlussmodell
	 * @var \SoapVar
	 * @internal ST_Abschlussmodell
	 */
	protected $Abschlussmodell;
	
	/**
	 * Art der Beratung
	 * @var \SoapVar
	 * @internal ST_ArtDerBeratung
	 */
	protected $ArtDerBeratung;
	
	/**
	 * Übergabeform der Bedingungen
	 * @var \SoapVar
	 * @internal ST_BedingungUebergabeform
	 */
	protected $BedingungUebergabeform;
	
	/**
	 * Attribut zur Feststellung, wie die Willenserklärung erfolgt
	 * @var \SoapVar
	 * @internal ST_Unterschriftsverfahren
	 */
	protected $Unterschriftsverfahren;
	
	/**
	 * Kenntnisnahme der Datenschutzerklärung
	 * @var \SoapVar
	 * @internal ST_DatenschutzerklaerungKenntnisnahme
	 */
	protected $DatenschutzerklaerungKenntnisnahme;
	
	/**
	 * Antragsart
	 * @var \SoapVar
	 * @internal ST_Antragsart
	 */
	protected $Antragsart;
	
	public function getHauptfaelligkeit() {
		return $this->Hauptfaelligkeit;
	}
	
	public function setHauptfaelligkeit(\SoapVar $oHauptfaelligkeit) {
		$this->Hauptfaelligkeit = $oHauptfaelligkeit;
		return $this;
	}
	
	public function getAktionskennzeichen() {
		return $this->Aktionskennzeichen;
	}
	
	public function setAktionskennzeichen(\SoapVar $oAktionskennzeichen) {
		$this->Aktionskennzeichen = $oAktionskennzeichen;
		return $this;
	}
	
	public function getAntragsdatum() {
		return $this->Antragsdatum;
	}
	
	public function setAntragsdatum(\SoapVar $oAntragsdatum) {
		$this->Antragsdatum = $oAntragsdatum;
		return $this;
	}
	
	public function getBedingungenZurKenntnisGenommen() {
		return $this->BedingungenZurKenntnisGenommen;
	}
	
	public function setBedingungenZurKenntnisGenommen(\SoapVar $oBedingungenZurKenntnisGenommen) {
		$this->BedingungenZurKenntnisGenommen = $oBedingungenZurKenntnisGenommen;
		return $this;
	}
	
	public function getTelefonwerbungErwuenscht() {
		return $this->TelefonwerbungErwuenscht;
	}
	
	public function setTelefonwerbungErwuenscht(\SoapVar $oTelefonwerbungErwuenscht) {
		$this->TelefonwerbungErwuenscht = $oTelefonwerbungErwuenscht;
		return $this;
	}
	
	public function getMailwerbungErwuenscht() {
		return $this->MailwerbungErwuenscht;
	}
	
	public function setMailwerbungErwuenscht(\SoapVar $oMailwerbungErwuenscht) {
		$this->MailwerbungErwuenscht = $oMailwerbungErwuenscht;
		return $this;
	}
	
	public function getBesondereVereinbarungen() {
		return $this->BesondereVereinbarungen;
	}
	
	public function setBesondereVereinbarungen(\SoapVar $oBesondereVereinbarungen) {
		$this->BesondereVereinbarungen = $oBesondereVereinbarungen;
		return $this;
	}
	
	public function getAktenzeichenVM() {
		return $this->AktenzeichenVM;
	}
	
	public function setAktenzeichenVM(\SoapVar $oAktenzeichenVM) {
		$this->AktenzeichenVM = $oAktenzeichenVM;
		return $this;
	}
	
	public function getAktenzeichenVN() {
		return $this->AktenzeichenVN;
	}
	
	public function setAktenzeichenVN(\SoapVar $oAktenzeichenVN) {
		$this->AktenzeichenVN = $oAktenzeichenVN;
		return $this;
	}
	
	public function getEinwilligungInformationsanfrage() {
		return $this->EinwilligungInformationsanfrage;
	}
	
	public function setEinwilligungInformationsanfrage(\SoapVar $oEinwilligungInformationsanfrage) {
		$this->EinwilligungInformationsanfrage = $oEinwilligungInformationsanfrage;
		return $this;
	}
	
	public function getVVGBeratungsverzicht() {
		return $this->VVGBeratungsverzicht;
	}
	
	public function setVVGBeratungsverzicht(\SoapVar $oVVGBeratungsverzicht) {
		$this->VVGBeratungsverzicht = $oVVGBeratungsverzicht;
		return $this;
	}
	
	public function getAntragUnterschrieben() {
		return $this->AntragUnterschrieben;
	}
	
	public function setAntragUnterschrieben(\SoapVar $oAntragUnterschrieben) {
		$this->AntragUnterschrieben = $oAntragUnterschrieben;
		return $this;
	}
	
	public function getZustimmungFinanzdienstleister() {
		return $this->ZustimmungFinanzdienstleister;
	}
	
	public function setZustimmungFinanzdienstleister(\SoapVar $oZustimmungFinanzdienstleister) {
		$this->ZustimmungFinanzdienstleister = $oZustimmungFinanzdienstleister;
		return $this;
	}
	
	public function getDatenschutzerklaerungUnterschrieben() {
		return $this->DatenschutzerklaerungUnterschrieben;
	}
	
	public function setDatenschutzerklaerungUnterschrieben(\SoapVar $oDatenschutzerklaerungUnterschrieben) {
		$this->DatenschutzerklaerungUnterschrieben = $oDatenschutzerklaerungUnterschrieben;
		return $this;
	}
	
	public function getAbschlussmodell() {
		return $this->Abschlussmodell;
	}
	
	public function setAbschlussmodell(\SoapVar $oAbschlussmodell) {
		$this->Abschlussmodell = $oAbschlussmodell;
		return $this;
	}
	
	public function getArtDerBeratung() {
		return $this->ArtDerBeratung;
	}
	
	public function setArtDerBeratung(\SoapVar $oArtDerBeratung) {
		$this->ArtDerBeratung = $oArtDerBeratung;
		return $this;
	}
	
	public function getBedingungUebergabeform() {
		return $this->BedingungUebergabeform;
	}
	
	public function setBedingungenUebergabeform(\SoapVar $oBedingungenUebergabeform) {
		$this->BedingungUebergabeform = $oBedingungenUebergabeform;
		return $this;
	}
	
	public function getUnterschriftsverfahren() {
		return $this->Unterschriftsverfahren;
	}
	
	public function setUnterschriftsverfahren(\SoapVar $oUnterschriftsverfahren) {
		$this->Unterschriftsverfahren = $oUnterschriftsverfahren;
		return $this;
	}
	
	public function getDatenschutzerklaerungKenntnisnahme() {
		return $this->DatenschutzerklaerungKenntnisnahme;
	}
	
	public function setDatenschutzerklaerungKenntnisnahme(\SoapVar $oDatenschutzerklaerungKenntnisnahme) {
		$this->DatenschutzerklaerungKenntnisnahme = $oDatenschutzerklaerungKenntnisnahme;
		return $this;
	}
	
	public function Antragsart() {
		return $this->Antragsart;
	}
	
	public function setAntragsart(\SoaVar $oAntragsart) {
		$this->Antragsart = $oAntragsart;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Antrag',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}