<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

class Person extends Partner {

	/**
	 * Vorname
	 * @var \SoapVar
	 * @internal ST_Text030
	 */
	protected $Vorname;
	
	/**
	 * Geburtsdatum
	 * @var \SoapVar
	 * @internal ST_Datum
	 */
	protected $Geburtsdatum;
	
	/**
	 * Geschlecht
	 * @var \SoapVar
	 * @internal ST_Geschlecht
	 */
	protected $Geschlecht;
	
	/**
	 * Titel / akademischer Grad
	 * @var \SoapVar
	 * @internal ST_Text017
	 */
	protected $Titel;
	
	/**
	 * Geburtsort
	 * @var \SoapVar
	 * @internal ST_Text025
	 */
	protected $Geburtsort;
	
	/**
	 * Staatsangehörigkeit
	 * @var \SoapVar
	 * @internal ST_Laenderkennzeichen
	 */
	protected $Stsangehoerigkeit;
	
	/**
	 * Familienstand
	 * @var \SoapVar
	 * @internal ST_Familienstand
	 */
	protected $Familienstand;
	
	/**
	 * Adelsprädikat
	 * @var \SoapVar
	 * @internal ST_Text017
	 */
	protected $Adelspraedikat;
	
	/**
	 * Ausweis
	 * @var \SoapVar
	 * @internal CT_Ausweis
	 */
	protected $Ausweis;
	
	/**
	 * Liefert den Vornamen
	 * @return \SoapVar
	 */
	public function getVorname() {
		return $this->Vorname;
	}
	
	/**
	 * Setzt den Vornamen
	 * @param \SoapVar $oVorname
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setVorname(\SoapVar $oVorname) {
		$this->Vorname = $oVorname;
		return $this;
	}
	
	/**
	 * Liefert das Geburtsdatum
	 * @return \SoapVar
	 */
	public function getGeburtsdatum() {
		return $this->Geburtsdatum;
	}
	
	/**
	 * Setzt das Geburtsdatum
	 * @param \SoapVar $oGeburtsdatum
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setGeburtsdatum(\SoapVar $oGeburtsdatum) {
		$this->Geburtsdatum = $oGeburtsdatum;
		return $this;
	}
	
	/**
	 * Liefert das Geschlecht
	 * @return \SoapVar
	 */
	public function getGeschlecht() {
		return $this->Geschlecht;
	}
	
	/**
	 * Setzt das Geschlecht
	 * @param \SoapVar $oGeschlecht
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setGeschlecht(\SoapVar $oGeschlecht) {
		$this->Geschlecht = $oGeschlecht;
		return $this;
	}
	
	/**
	 * Liefert den Titel
	 * @return \SoapVar
	 */
	public function getTitel() {
		return $this->Titel;
	}
	
	/**
	 * Setzt den Titel
	 * @param \SoapVar $oTitel
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setTitel(\SoapVar $oTitel) {
		$this->Titel = $oTitel;
		return $this;
	}
	
	/**
	 * Liefert den Geburtsort
	 * @return \SoapVar
	 */
	public function getGeburtsort() {
		return $this->Geburtsort;
	}
	
	/**
	 * Setzt den Geburtsort
	 * @param \SoapVar $oGeburtsort
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setGeburtsort(\SoapVar $oGeburtsort) {
		$this->Geburtsort = $oGeburtsort;
		return $this;
	}
	
	/**
	 * Liefert die Staatsangehörigkeit
	 * @return \SoapVar
	 */
	public function getStsangehoerigkeit() {
		return $this->Stsangehoerigkeit;
	}
	
	/**
	 * Setzt die Staatsangehörigkeit
	 * @param \SoapVar $oStsangehoerigkeit
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setStsangehoerigkeit(\SoapVar $oStsangehoerigkeit) {
		$this->Stsangehoerigkeit = $oStsangehoerigkeit;
		return $this;
	}
	
	/**
	 * Liefert den Familienstand
	 * @return \SoapVar
	 */
	public function getFamilienstand() {
		return $this->Familienstand;
	}
	
	/**
	 * Setzt den Familienstand
	 * @param \SoapVar $oFamilienstand
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setFamilienstand(\SoapVar $oFamilienstand) {
		$this->Familienstand = $oFamilienstand;
		return $this;
	}
	
	/**
	 * Liefert das Adelsprädikat
	 * @return \SoapVar
	 */
	public function getAdelspraedikat() {
		return $this->Adelspraedikat;
	}
	
	/**
	 * Setzt das Adelsprädikat
	 * @param \SoapVar $oAdelspraedikat
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setAdelspraedikat(\SoapVar $oAdelspraedikat) {
		$this->Adelspraedikat = $oAdelspraedikat;
		return $this;
	}
	
	/**
	 * Liefert den Ausweis
	 * @return \SoapVar
	 */
	public function getAusweis() {
		return $this->Ausweis;
	}
	
	/**
	 * Setzt den Ausweis
	 * @param \SoapVar $oAusweis
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Person
	 */
	public function setAusweis(\SoapVar $oAusweis) {
		$this->Ausweis = $oAusweis;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/partner',
			'Person',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}