<?php
namespace MMNewmedia\BiPRO\Entity\Allgemein;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * ProzessFehler Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.allgemein
 * @since 2016-10-17
 * @version
 */
class ProzessFehler implements BiPROEntity {
	
	/**
	 * Versionsattribut
	 * @var \SoapVar
	 * @internal ST_Version
	 */
	protected $BiproVersion;
	
	/**
	 * Status
	 * @var \SoapVar
	 * @internal ST_Status
	 */
	protected $Status;
	
	/**
	 * Liefert das Versionsattribut
	 * @return SoapVar
	 */
	public function getBiproVersion() {
		return $this->BiproVersion;
	}
	
	/**
	 * Setzt das Versionsattribut
	 * @param \SoapVar $oBiproVersion
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\ProzessAntwort
	 */
	public function setBiproVersion(\SoapVar $oBiproVersion) {
		$this->BiproVersion = $oBiproVersion;
		return $this;
	}
	
	/**
	 * Liefert den Status
	 * @return SoapVar
	 */
	public function getStatus() {
		return $this->Status;
	}
	
	/**
	 * Setzt den Status
	 * @param \SoapVar $oStatus
	 * @return \MMNewmedia\BiPRO\Entity\Allgemein\ProzessAntwort
	 */
	public function setStatus(\SoapVar $oStatus) {
		$this->Status = $oStatus;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://www.bipro.net/namespace/allgemein',
			'ProzessFehler',
			'http://www.bipro.net/namespace/allgemein'
		);
	
		return $oEncodedObject;
	}
}