<?php
namespace MMNewmedia\BiPRO\Norm410\Model;

use MMNewmedia\BiPRO\Entity\UsernameToken;
use MMNewmedia\BiPRO\Entity\Security;

/**
 * WsseHeader für den Security Token Request nach BiPRO Norm 410 (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage norm410.model
 * @since 2016-03-03
 * @version
 */
class WsseHeader extends \SoapHeader {
	
	/**
	 * WSSE Namensraum
	 * @var string
	 */
	protected $sWsseNs = 'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd';
	
	/**
	 * Konstruktor
	 *
	 * @param string $sUsername Bneutzername
	 * @param string $sPassword Passwort
	 */
	public function __construct($sUsername, $sPassword) {
		$oSecurity = $this->getSecurityNode($sUsername, $sPassword);
		parent::__construct($this->sWsseNs, 'Security', $oSecurity, true);
	}
	
	/**
	 * Erzeugt ein WSSE Objekt und liefert es als Soap Variable aus
	 *
	 * @param string $sUsername Benutzername
	 * @param string $sPassword Passwort
	 * @return \SoapVar
	 */
	protected function getSecurityNode($sUsername, $sPassword) {
		$oUsernameToken = new UsernameToken();
		$oUsernameToken->setUsername(new \SoapVar(
			$sUsername,
			XSD_STRING,
			null,
			null,
			'Username',
			$this->sWsseNs
		));
		
		$oUsernameToken->setPassword(new \SoapVar(
			$sPassword,
			XSD_STRING,
			'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText',
			null,
			'Password',
			$this->sWsseNs
		));
	
		$oSecurity = new Security();
		$oSecurity->setUsernameToken($oUsernameToken->encode());
	
		return $oSecurity->encode();
	}
}