<?php
namespace MMNewmedia\BiPRO\Entity\Partner;

use MMNewmedia\BiPRO\Entity\BiPROEntity;

/**
 * Einkommen Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.partner
 * @since 2016-10-18
 * @version
 */
class Einkommen implements BiPROEntity {
	
	/**
	 * Anzahl der Gehälter pro Jahr
	 * @var \SoapVar
	 * @internal ST_Dezimalzahl
	 */
	protected $AnzahlGehaelterProJahr;
	
	/**
	 * Nettomonatseinkommen
	 * @var \SoapVar
	 * @internal ST_Betrag
	 */
	protected $Nettomonatseinkommen;
	
	/**
	 * Nettojahreseinkommen
	 * @var \SoapVar
	 * @internal ST_Betrag
	 */
	protected $Nettojahreseinkommen;
	
	/**
	 * Währung
	 * @var \SoapVar
	 * @internal ST_Waehrungsschluessel
	 */
	protected $Waehrung;
	
	/**
	 * Bruttojahreseinkommen
	 * @var \SoapVar
	 * @internal ST_Betrag
	 */
	protected $Bruttomonatseinkommen;
	
	/**
	 * Bruttojahreseinkommen
	 * @var \SoapVar
	 * @internal ST_Betrag
	 */
	protected $Bruttojahreseinkommen;
	
	/**
	 * Liefert die Anzahl der Gehälter pro Jahr
	 * @return \SoapVar
	 */
	public function getAnzahlGehaelterProJahr() {
		return $this->AnzahlGehaelterProJahr;
	}
	
	/**
	 * Setzt die Anzahl der Gehälter pro Jahr
	 * @param \SoapVar $oAnzahlGehaelterProJahr
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Einkommen
	 */
	public function setAnzahlGehaelterProJahr(\SoapVar $oAnzahlGehaelterProJahr) {
		$this->AnzahlGehaelterProJahr = $oAnzahlGehaelterProJahr;
		return $this;
	}
	
	/**
	 * Liefert das Nettomonatseinkommen
	 * @return \SoapVar
	 */
	public function getNettomonatseinkommen() {
		return $this->Nettomonatseinkommen;
	}
	
	/**
	 * Setzt das Nettomonatseinkommen
	 * @param \SoapVar $oNettomonatseinkommen
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Einkommen
	 */
	public function setNettomonatseinkommen(\SoapVar $oNettomonatseinkommen) {
		$this->Nettomonatseinkommen = $oNettomonatseinkommen;
		return $this;
	}
	
	/**
	 * Liefert das Nettojahreseinkommen
	 * @return \SoapVar
	 */
	public function getNettojahreseinkommen() {
		return $this->Nettojahreseinkommen;
	}
	
	/**
	 * Setzt das Nettojahreseinkommen
	 * @param \SoapVar $oNettojahreseinkommen
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Einkommen
	 */
	public function setNettojahreseinkommen(\SoapVar $oNettojahreseinkommen) {
		$this->Nettojahreseinkommen = $oNettojahreseinkommen;
		return $this;
	}
	
	/**
	 * Liefert die Währung
	 * @return \SoapVar
	 */
	public function getWaehrung() {
		return $this->Waehrung;
	}
	
	/**
	 * Setzt die Währung
	 * @param \SoapVar $oWaehrung
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Einkommen
	 */
	public function setWaehrung(\SoapVar $oWaehrung) {
		$this->Waehrung = $oWaehrung;
		return $this;
	}
	
	/**
	 * Liefert das Bruttomonatseinkommen
	 * @return \SoapVar
	 */
	public function getBruttomonatseinkommen() {
		return $this->Bruttomonatseinkommen;
	}
	
	/**
	 * Setzt das Bruttomonatseinkommen
	 * @param \SoapVar $oBruttomonatseinkommen
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Einkommen
	 */
	public function setBruttomonatseinkommen(\SoapVar $oBruttomonatseinkommen) {
		$this->Bruttomonatseinkommen = $oBruttomonatseinkommen;
		return $this;
	}
	
	/**
	 * Liefert das Bruttojahreseinkommen
	 * @return \SoapVar
	 */
	public function getBruttojahreseinkommen() {
		return $this->Bruttojahreseinkommen;
	}
	
	/**
	 * Setzt das bruttojahreseinkommen
	 * @param \SoapVar $oBruttojahreseinkommen
	 * @return \MMNewmedia\BiPRO\Entity\Partner\Einkommen
	 */
	public function setBruttojahreseinkommen(\SoapVar $oBruttojahreseinkommen) {
		$this->Bruttojahreseinkommen = $oBruttojahreseinkommen;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'Einkommen',
			'http://www.bipro.net/namespace/partner'
		);
	
		return $oEncodedObject;
	}
}