<?php
namespace MMNewmedia\BiPRO\Entity\Tarifierung;

/**
 * OfferResponse Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity.tarifierung
 * @since 2016-10-18
 * @version
 */
class OfferResponse implements ProzessAntwort {
	/**
	 * Antwort
	 * @var \SoapVar
	 */
	protected $Antwort;
	
	/**
	 * Liefert die Antwort
	 * @return \SoapVar
	 * @internal CT_Angebot
	 */
	public function getAntwort() {
		return $this->Antwort;
	}
	
	/**
	 * Setzt die Antwort
	 * @param \SoapVar $oAntwort
	 * @return \MMNewmedia\BiPRO\Entity\Tarifierung\OfferResponse
	 */
	public function setAntwort(\SoapVar $oAntwort) {
		$this->Antwort = $oAntwort;
		return $this;
	}
	
	/**
	 * @see \MMNewmedia\BiPRO\Entity\BiPROEntity::encode()
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			null,
			'OfferResponse',
			'http://www.bipro.net/namespace/tarifierung'
		);
	
		return $oEncodedObject;
	}
}