<?php
namespace MMNewmedia\BiPRO\Entity;

/**
 * Lifetime Model nach BiPRO Norm 410 (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2016-03-03
 * @version
 */
class Lifetime {
	
	/**
	 * Created
	 * @var \SoapVar
	 */
	protected $Created;
	
	/**
	 * Expires
	 * @var \SoapVar
	 */
	protected $Expires;
	
	/**
	 * Setzt die Beginnzeit des Security Tokens
	 * @param \SoapVar $sCreated
	 */
	public function setCreated(\SoapVar $oCreated) {
		$this->Created = $oCreated;
	}
	
	/**
	 * Liefert die Beginnzeit des Security Tokens
	 * @return \SoapVar
	 */
	public function getCreated() {
		return $this->Created;
	}
	
	/**
	 * Setzt die Beginnzeit des Security Tokens
	 * @param \SoapVar $sExpires
	 */
	public function setExpires(\SoapVar $oExpires) {
		$this->Expires = $oExpires;
	}
	
	/**
	 * Liefert die Beginnzeig des Security Tokens
	 * @return \SoapVar
	 */
	public function getExpires() {
		return $this->Expires;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://schemas.xmlsoap.org/ws/2005/02/trust',
			'Lifetime',
			'http://schemas.xmlsoap.org/ws/2005/02/trust'
		);
	
		return $oEncodedObject;
	}
}