<?php
namespace MMNewmedia\BiPRO\Norm410\Model;

/**
 * AuthDecorator Klasse (utf-8)
 * Überprüft die Credentials und führt dann die vom Webservice angefragten Methoden ab
 * 
 * @author MarcelMaaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage norm410.model
 * @since 2016-03-03
 * @version
 */
class AuthDecorator {
	
	/**
	 * Name der Klasse, welche die Webservice Methoden enthält
	 * @var string
	 */
	protected $sClassName = '';
	
	/**
	 * Ist der User authentifiziert
	 * @var boolean
	 */
	protected $bAuthenticated = false;
	
	/**
	 * Prüft Benutzernamen und Passwort und führt dann die übergebene Methode aus
	 * 
	 * @param 	string 	$sMethodName Name der auszuführenden Methode
	 * @param 	array 	$aArguments	 Argumente für die auszufhrende Methode
	 * @return	object
	 * @throws \SoapFault
	 */
	public function __call($sMethodName, $aArguments) {
		if (!method_exists($this->sClassName, $sMethodName)) {
			throw new \SoapFault(
				'Server',
				sprintf(
					'Die Methode %s existiert nicht.',
					$sMethodName
				)
			);
		}
		
		if (!$this->getAuthenticated()) {
			throw new \SoapFault(
				'Server',
				sprintf(
					'Bitte überprüfen Sie die Angaben zu Username und Password.'		
				)
			);
		}
		
		return call_user_func_array(
			[$this->sClassName, $sMethodName], 
			$aArguments
		);
	}
	
	/**
	 * Wird automatisch vom empfangenen Soap Header aufgerufen und prüft die Credentials
	 * 
	 * @param object $WsseHeader
	 */
	public function Security($oSecurity) {
		if ($oSecurity->UsernameToken->Username == 'Foo' && $oSecurity->UsernameToken->Password == 'Bar') {
			$this->setAuthenticated(true);
		}
	}
	
	/**
	 * Liefert den Klassennamen der Klasse, die die Webservice Methoden beinhaltet
	 * 
	 * @return string
	 */
	public function getClassName() {
		return $this->sClassName;
	}
	
	/**
	 * Setzt den Klassennamen der Klasse, die die Webservice Methoden beinhaltet
	 * 
	 * @param string $sClassName
	 */
	public function setClassName($sClassName){
		$this->sClassName = $sClassName;
	}
	
	/**
	 * Liefert das Flag, ob ein Request mit den gelieferten Credentials positiv authentifiziert wurde
	 * 
	 * @return boolean
	 */
	public function getAuthenticated() {
		return $this->bAuthenticated;
	}
	
	/**
	 * Setzt das Flag, ob ein Request mit den gelieferten Credentials positiv authentifiziert wurde
	 * 
	 * @param boolean $bAuthenticated
	 */
	public function setAuthenticated($bAuthenticated) {
		$this->bAuthenticated = $bAuthenticated;
	}
}