<?php
namespace MMNewmedia\BiPRO\Entity;

/**
 * RequestedSecurityToken Entity nach BiPRO Norm (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage entity
 * @since 2013-03-03
 * @version
 */
class RequestedSecurityToken {
	
	/**
	 * SecurityContextToken
	 * @var \SoapVar
	 */
	protected $SecurityContextToken;
	
	/**
	 * Liefert den SecurityContextToken
	 * @return \SoapVar
	 */
	public function getSecurityContextToken() {
		return $this->SecurityContextToken;
	}
	
	/**
	 * Setzt den SecurityContextToken
	 * @param \SoapVar $oSecurityContextToken
	 */
	public function setSecurityContextToken(\SoapVar $oSecurityContextToken) {
		$this->SecurityContextToken = $oSecurityContextToken;
	}
	
	/**
	 * Liefert dieses Entity als SoapVar
	 * @return \SoapVar
	 */
	public function encode() {
		$oEncodedObject = new \SoapVar(
			$this,
			SOAP_ENC_OBJECT,
			null,
			'http://schemas.xmlsoap.org/ws/2005/02/trust',
			'RequestedSecurityToken',
			'http://schemas.xmlsoap.org/ws/2005/02/trust'
		);
		
		return $oEncodedObject;
	}
}