<?php
namespace MMNewmedia\BiPRO\Loader;

/**
 * Standard Autoloader (utf-8)
 * 
 * @author Marcel Maaß <info@mm-newmedia.de>
 * @copyright 2016 MM Newmedia <http://www.mm-newmedia.de>
 * @package de.mmnewmedia.bipro
 * @subpackage loader
 * @since 2016-03-03
 * @version
 */
class StandardAutoloader {
	
	/**
	 * Classmap mit allen verfügbaren Klassen
	 * @var array
	 */
	protected $aClassMap = [];
	
	/**
	 * Setzt die Classmap
	 * @param array $aClassMap
	 */
	public function addClassMap($aClassMap) {
		$this->aClassMap = array_merge($this->aClassMap, $aClassMap);
	}
	
	/**
	 * Liefert eine neue Instanz der aufgerufenen Klasse
	 * @param string $sClass
	 */
	public function autoload($sClass) {
		if (isset($this->aClassMap[$sClass])) {
			include $this->aClassMap[$sClass];
		}
	}
	
	/**
	 * Registriert diese Autoloader Klasse im SPL Autoload Stack
	 */
	public function register() {
		spl_autoload_extensions('.php');
		spl_autoload_register([$this, 'autoload']);
	}
}