<?php
namespace MMNewmedia\BiPRO\Norm410;

use MMNewmedia\BiPRO\Norm410\Model\WsseHeader;
use MMNewmedia\BiPRO\Entity\RequestSecurityToken;
use MMNewmedia\BiPRO\Loader\StandardAutoloader;

// Autoloader initialisieren
require_once('../lib/loader/StandardAutoloader.php');
$aClassMap = require_once('../autoload_classmap.php');

$oAutoloader = new StandardAutoloader();
$oAutoloader->addClassMap($aClassMap);
$oAutoloader->register();

try {
	$sWsdl = 'http://localhost/vergleichen-und-sparen.de/testarea/bipro/norm410/view/assets/wsdl/SecurityTokenService_2.1.0.1.0.wsdl';
	$oClient = new \SoapClient(
		$sWsdl,
		[
			'trace' 		=> true,
			'exception' 	=> true,
			'cache_wsdl' 	=> WSDL_CACHE_NONE,
			'compression' 	=> SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP,
			'soap_version' 	=> SOAP_1_2,
		]
	);
	
	$oHeaders = new WsseHeader('Foo', 'Bar');
	$oClient->__setSoapHeaders($oHeaders);
	
	$oRequestType = new \SoapVar(
		'http://schemas.xmlsoap.org/ws/2005/02/trust/Issue',
		XSD_STRING,
		null,
		null,
		'RequestType',
		'http://schemas.xmlsoap.org/ws/2005/02/trust'
	);
	
	$oTokenType = new \SoapVar(
		'http://schemas.xmlsoap.org/ws/2005/02/sc/sct',
		XSD_STRING,
		null,
		null,
		'TokenType',
		'http://schemas.xmlsoap.org/ws/2005/02/trust'
	);
	
	$oRequestSecurityToken = new RequestSecurityToken();
	$oRequestSecurityToken->setRequestType($oRequestType);
	$oRequestSecurityToken->setTokenType($oTokenType);
	
	$oRequestSecurityTokenSoapVar = $oRequestSecurityToken->encode();
	$oResult = $oClient->RequestSecurityToken($oRequestSecurityTokenSoapVar);
	
	$sSecurityToken = $oResult->any['RequestedSecurityToken']->any;
	$sBeginn = $oResult->any['Lifetime']->Created->_;
	$sAblauf = $oResult->any['Lifetime']->Expires->_;
	
	echo '<h2>Security Token</h2>';
	echo '<p><strong>Bezeichnung:</strong> ' . $sSecurityToken . '<br><strong>Beginn:</strong> ' . $sBeginn . '<br><strong>Ablauf:</strong> ' . $sAblauf . '</p>';
	
	$oDocRequest = new \DomDocument();
	$oDocRequest->formatOutput = true;
	$oDocRequest->loadXML($oClient->__getLastRequest());
	
	echo '<h2>Request</h2>';
	echo '<p><pre>' . htmlentities($oDocRequest->saveXML()) . '</pre></p>';
	
	$oDocResponse = new \DomDocument();
	$oDocResponse->formatOutput = true;
	$oDocResponse->loadXML($oClient->__getLastResponse());
	
	echo '<h2>Response</h2>';
	echo '<p><pre>'. htmlentities($oDocResponse->saveXML()) . '</pre></p>';
	
} catch (\SoapFault $e) {
	// error handling
}